% edu_switch_time.m
% Set B such that the switch to education happens at time edu_switch
% Takes as given time of switch to empowerment (computed previously)
% Uses analytical solutions for choices, utilities are computed numerically
% Version February 2008

% Model parameters
param;

% Initial condition is H=1 for both men and women
% Save H_f for computing growth rates
H_f_vector=ones(1,10);

% Compute choices under no-education regime.
% Compute choices and utilities under no-education regime
c_m_nm=A*(alph*(1+sig)/(alph*(1+sig)+delt))^alph/(1+sig);
c_f_nm=A*sig*(alph*(1+sig)/(alph*(1+sig)+delt))^alph/(1+sig);
n_nm=delt/(phi*(alph*(1+sig)+delt));

% Set B
Bhi=80;
Blo=5;
B=20;

B_count=1;
while B_count<15;

    % Value function parameters (needed for computing choices)
    a2=(1+sig)*(2*alph+(1-alph)*bet*gam_f-alph*(1-bet)*gam_m)/(2-(1-bet)*gam_m-bet*gam_f);
    b3=(1+sig)*(2*(1-alph)-(1-alph)*bet*gam_f+alph*(1-bet)*gam_m)/(2-(1-bet)*gam_m-bet*gam_f);

    % Intialize outcome; Switch should happen before political switch
    edu_switch_utility=zeros(1,crit_time-1);

    % Go through the possible switching times; assume it does not happen right
    % away
    count=2;
    while count<=crit_time-1;

        % Utility is computed by forward iteration
        % Utility in first period (old regime for sure)
        V_m=log(c_m_nm)+sig*log(c_f_nm)+delt*log(n_nm);

        % Moving to second period
        % The discount factor to be applied is the male discount factor
        fac=gam_m;

        if count>2;

            % We are still in the no-education regime; updated utility
            % accordingly

            % Update utilities; here the male discount factor applies
            V_m=V_m+fac*((1+sig)*(log(c_m_nm)+log(c_f_nm))/2+delt*log(n_nm));

            % Next male and female human capital
            Hpr_m=1;
            Hpr_f=1;

        else;
            % We are already in the education regime
            % Assume that there is no vote for empowerment yet (because that is
            % how we calibrate that)
            thet=thet_path(1,2);

            % Current male and female human capital
            H_m=1;
            H_f=1;

            % This period's consumption values
            % Next period consumption values
            c_m_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f^alph*H_m^(1-alph)/(1+sig);
            c_f_em=sig*A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f^alph*H_m^(1-alph)/(1+sig);

            % Other choices:
            e_m_em=phi*(gam_m/2)*thet*a2/(delt-(gam_m/2)*thet*(a2+b3));
            e_f_em=phi*(gam_m/2)*thet*b3/(delt-(gam_m/2)*thet*(a2+b3));
            n_em=(delt-(gam_m/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));

            % Update utilities; here the male discount factor applies
            V_m=V_m+fac*((1+sig)*(log(c_m_em)+log(c_f_em))/2+delt*log(n_em));

            % Next male and female human capital
            Hpr_m=(B*e_m_em)^thet*H_f^bet*H_m^(1-bet);
            Hpr_f=(B*e_f_em)^thet*H_f^bet*H_m^(1-bet);

        end;

        % Now iterate on this for a while
        i=2;
        while i<=30;

            % New theta value
            thet=thet_path(1,min(count+i,path_length));

            % This period's male and female human capital
            H_m=Hpr_m;
            H_f=Hpr_f;
            
            if count==edu_switch_target;
                H_f_vector(1,i+1)=H_f;
            end;
            
            %  Consumption values
            c_m_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f^alph*H_m^(1-alph)/(1+sig);
            c_f_em=sig*A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f^alph*H_m^(1-alph)/(1+sig);

            c_m_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f^alph*H_m^(1-alph)/2;
            c_f_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f^alph*H_m^(1-alph)/2;

            % Other choices:
            e_m_em=phi*(gam_m/2)*thet*a2/(delt-(gam_m/2)*thet*(a2+b3));
            e_f_em=phi*(gam_m/2)*thet*b3/(delt-(gam_m/2)*thet*(a2+b3));
            n_em=(delt-(gam_m/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));

            % Other choices:
            e_m_es=phi*(gam/2)*thet*a2/(delt-(gam/2)*thet*(a2+b3));
            e_f_es=phi*(gam/2)*thet*b3/(delt-(gam/2)*thet*(a2+b3));
            n_es=(delt-(gam/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));

            % The discount factor to be applied is the mixed discount factor
            fac=gam*fac;

            % Now distinguish three cases:
            if count>i+1;
                % We are still in the no-education regime; updated utility
                % accordingly

                % Update utilities; here the male discount factor applies
                V_m=V_m+fac*((1+sig)*(log(c_m_nm)+log(c_f_nm))/2+delt*log(n_nm));

                % Next male and female human capital
                Hpr_m=1;
                Hpr_f=1;

            else;
                if crit_time<=i+1;
                    % We are already in the empowerment regime

                    % Next male and female human capital
                    Hpr_m=(B*e_m_es)^thet*H_f^bet*H_m^(1-bet);
                    Hpr_f=(B*e_f_es)^thet*H_f^bet*H_m^(1-bet);

                    % Update utility
                    V_m=V_m+fac*((1+sig)*(log(c_m_es)+log(c_f_es))/2+bet*log(n_es));

                else;
                    % We are still operating under patriarchy

                    % Next male and female human capital
                    Hpr_m=(B*e_m_em)^thet*H_f^bet*H_m^(1-bet);
                    Hpr_f=(B*e_f_em)^thet*H_f^bet*H_m^(1-bet);

                    % Update utility
                    V_m=V_m+fac*((1+sig)*(log(c_m_em)+log(c_f_em))/2+bet*log(n_em));

                end;

            end;

            if i<=10;
            H_f
            end;
            i=i+1;

        end;

        % Save utility implied by this education switching time
        edu_switch_utility(1,count)=V_m;

        count=count+1;

    end;

    disp(['Utilities: ' num2str(edu_switch_utility)]); 
    [x time_index]=max(edu_switch_utility(1,2:crit_time-1));
    time_index=time_index+1;

    disp(['Switching time is thus: ' num2str(time_index)]); 

    disp(['Current B is: ' num2str(B)]);
    % Now adjust B
    if time_index<edu_switch_target;
        % Move B down
        Bhi=B;
        B=0.5*B+0.5*Blo;
        
    else;
        % Move B up
        Blo=B;
        B=0.5*B+0.5*Bhi;       
    end;
    
    B=floor(B);
    
    B_count=B_count+1;
    
end;



disp(['Female human capital: ' num2str(H_f_vector)]); 
disp(['Growth rates: ' num2str(log(H_f_vector(1,2:10))-log(H_f_vector(1,1:9)))]); 
disp(['Annualized growth rates (period 25 years): ' num2str((log(H_f_vector(1,2:10))-log(H_f_vector(1,1:9)))/25)]); 
disp(['Fertility (beginning of transition): ' num2str(2*n_nm)]); 
disp(['Fertility (end of transition): ' num2str(2*n_es)]); 


