% graphs.m
% Plot outcomes

close all;

% Time axis
time=[1:1:horizon];

% Show outcome over time

figure;
subplot(1,1,1);
gr=plot(time,thet_path,'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon .3 .8]);
xx=xlabel('Time');
yy=ylabel('Theta');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(1,1,1);
gr=plot(time,H_f_m(1,1:horizon),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 0.9 max(H_f_o(1,1:horizon))]);
xx=xlabel('Time');
yy=ylabel('Human Capital');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(1,1,1);
gr=plot(time,H_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time,H_f_o(1,1:horizon),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0.9 max(H_f_o(1,1:horizon))]);
xx=xlabel('Time');
yy=ylabel('Human Capital');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(2,1,1);
gr=plot(time,2*n_m,'b-');
hold on;
gr2=plot(time,2*n_o,'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time,e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time,e_f_o(1,1:horizon),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

% Now some subplots of the same

figure;
subplot(2,1,1);
gr=plot(time(1,1:2),2*n_m(1,1:2),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:2),e_f_m(1,1:2),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;



figure;
subplot(2,1,1);
gr=plot(time(1,1:3),2*n_m(1,1:3),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:3),e_f_m(1,1:3),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;


figure;
subplot(2,1,1);
gr=plot(time(1,1:7),2*n_m(1,1:7),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:7),e_f_m(1,1:7),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;


figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
set(gr,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:2),2*n_o(1,1:2),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:2),e_f_o(1,1:2),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:3),2*n_o(1,1:3),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:3),e_f_o(1,1:3),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;


figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:5),2*n_o(1,1:5),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:5),e_f_o(1,1:5),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:6),2*n_o(1,1:6),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:6),e_f_o(1,1:6),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:7),2*n_o(1,1:7),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:7),e_f_o(1,1:7),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;


figure;
subplot(2,1,1);
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:horizon),2*n_o(1,1:horizon),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'b-');
hold on;
gr2=plot(time(1,1:horizon),e_f_o(1,1:horizon),'r-');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

% Now the two figures for the paper in black and white
figure;
subplot(2,1,1);
gr2=plot(time(1,1:horizon),2*n_o(1,1:horizon),'k-');
hold on;
gr=plot(time(1,1:horizon),2*n_m(1,1:horizon),'k--');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
ll=legend('Optimal Empowerment','Permanent Patriarchy','Location','NorthEast');
axis([1 horizon 2 4.1]);
xx=xlabel('Time');
yy=ylabel('Fertility');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

subplot(2,1,2);
gr2=plot(time(1,1:horizon),e_f_o(1,1:horizon),'k-');
hold on;
gr=plot(time(1,1:horizon),e_f_m(1,1:horizon),'k--');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
ll=legend('Optimal Empowerment','Permanent Patriarchy','Location','SouthEast');
axis([1 horizon 0 0.11]);
xx=xlabel('Time');
yy=ylabel('Education');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

figure;
subplot(2,1,1);
gr2=plot(time,H_f_o(1,1:horizon),'k-');
hold on;
gr=plot(time,H_f_m(1,1:horizon),'k--');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
ll=legend('Optimal Empowerment','Permanent Patriarchy','Location','NorthWest');
axis([1 horizon 0 max(H_f_o(1,1:horizon))]);
xx=xlabel('Time');
yy=ylabel('Human Capital');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;

output_o=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_o(1,1:horizon).^alph.*H_m_o(1,1:horizon).^(1-alph);
output_m=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_m(1,1:horizon).^alph.*H_m_m(1,1:horizon).^(1-alph);

subplot(2,1,2);
gr2=plot(time,output_o,'k-');
hold on;
gr=plot(time,output_m,'k--');
set(gr,'LineWidth',2);
set(gr2,'LineWidth',2);
ll=legend('Optimal Empowerment','Permanent Patriarchy','Location','NorthWest');
axis([1 horizon 0 max(output_o)]);
xx=xlabel('Time');
yy=ylabel('Output');
set(xx,'Fontsize',16);
set(yy,'Fontsize',16);
hold off;



