% param.m
% Sets model parameters

sig=0.66;               % Weight on spouse's consumption
delt=0.66;              % Weight on number of children

gam_m=0.4;              % Male weight on children
gam_f=0.45;             % Female weight on child quality

alph=0.4;               % Production share of female h.c. in goods prod.

bet=0.5;                % Share of female h.c. in h.c. production
gam=(gam_m+gam_f)/2;    % Average weight

phi=0.25;                % Time cost of each child

A=1;                    % Constant in goods production function

% Time path for theta
thet_min=0.4;
thet_max=0.6;
thet_path=linspace(thet_min,thet_max,8);
thet_path=[thet_path thet_max thet_max];

path_length=size(thet_path,2);

% Period in which switch to education should occur
edu_switch_target=3;

% Horizon for plots
horizon=10;