% theta_crit.m
% Computes level that theta has to reach (for given other parameters) such
% as that the transition takes place under dynamic voting
% Uses analytical solutions for choices, utilities are computed numerically
% Version February 2008

close all;
clear all;
clear all;

% Model parameters

param;

% First step: Find a constant theta that is high enough that men would want to
% introduce empowerment today even if expecting empowerment tomorrow.
% Later, once the dynamic path reaches this level of theta, we know that
% empowerment is introduced for sure, giving us an upper bound for the
% switching time theta.

% Initial condition is H=1 for both (does not matter)

% Compute choices and utilities under education regime.

% B does not matter for the tradeoff either.
B=1;

% Value function parameters (needed for computing choices)
a2=(1+sig)*(2*alph+(1-alph)*bet*gam_f-alph*(1-bet)*gam_m)/(2-(1-bet)*gam_m-bet*gam_f);
b3=(1+sig)*(2*(1-alph)-(1-alph)*bet*gam_f+alph*(1-bet)*gam_m)/(2-(1-bet)*gam_m-bet*gam_f);

% Bracketing for theta.
thet_lo=0.1;
thet_hi=2;
thet=0.2;

count=1;
while count<=40;

    % Today's choices under patriarchy
    c_m_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph/(1+sig);
    c_f_em=sig*A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph/(1+sig);
    e_m_em=phi*(gam_m/2)*thet*a2/(delt-(gam_m/2)*thet*(a2+b3));
    e_f_em=phi*(gam_m/2)*thet*b3/(delt-(gam_m/2)*thet*(a2+b3));
    n_em=(delt-(gam_m/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));

    % And under empowerment
    c_m_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph/2;
    c_f_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph/2;
    e_m_es=phi*(gam/2)*thet*a2/(delt-(gam/2)*thet*(a2+b3));
    e_f_es=phi*(gam/2)*thet*b3/(delt-(gam/2)*thet*(a2+b3));
    n_es=(delt-(gam/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));
    
    % Next male and female human capital
    Hpr_m_em=(B*e_m_em)^thet;
    Hpr_m_es=(B*e_m_es)^thet;

    Hpr_f_em=(B*e_f_em)^thet;
    Hpr_f_es=(B*e_f_es)^thet;


    % Utility is computed by forward iteration
    % Utility in first period:
    V_m_em=log(c_m_em)+sig*log(c_f_em)+delt*log(n_em);
    V_m_es=log(c_m_es)+sig*log(c_f_es)+delt*log(n_es);

    % Next male and female human capital
    H_m_em=Hpr_m_em;
    H_m_es=Hpr_m_es;

    H_f_em=Hpr_f_em;
    H_f_es=Hpr_f_es;
    
    % Next period consumption values
    % From here on there is empowerment for sure - the m index refers to
    % the first period only!
    c_m_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_em^alph*H_m_em^(1-alph)/2;
    c_f_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_em^alph*H_m_em^(1-alph)/2;
   
    c_m_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_es^alph*H_m_es^(1-alph)/2;
    c_f_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_es^alph*H_m_es^(1-alph)/2;

    % The discount factor to be applied is the male discount factor
    fac=gam_m;

    % Update utilities; here the male discount factor applies
    V_m_em=V_m_em+fac*((1+sig)*(log(c_m_em)+log(c_f_em))/2+delt*log(n_es));
    V_m_es=V_m_es+fac*((1+sig)*(log(c_m_es)+log(c_f_es))/2+delt*log(n_es));
    
    % Next male and female human capital
    Hpr_m_em=(B*e_m_es)^thet*H_f_em^bet*H_m_em^(1-bet);
    Hpr_m_es=(B*e_m_es)^thet*H_f_es^bet*H_m_es^(1-bet);

    Hpr_f_em=(B*e_f_es)^thet*H_f_em^bet*H_m_em^(1-bet);
    Hpr_f_es=(B*e_f_es)^thet*H_f_es^bet*H_m_es^(1-bet);

    % Now iterate on this for a while
    i=1;
    while i<=30;
        % Male and female human capital
        H_m_em=Hpr_m_em;
        H_m_es=Hpr_m_es;

        H_f_em=Hpr_f_em;
        H_f_es=Hpr_f_es;
        
        % Consumption values
        c_m_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_em^alph*H_m_em^(1-alph)/2;
        c_f_em=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_em^alph*H_m_em^(1-alph)/2;
        
        c_m_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_es^alph*H_m_es^(1-alph)/2;
        c_f_es=A*((alph*(1+sig))/(alph*(1+sig)+delt))^alph*H_f_es^alph*H_m_es^(1-alph)/2;

        % Next male and female human capital
        Hpr_m_em=(B*e_m_es)^thet*H_f_em^bet*H_m_em^(1-bet);
        Hpr_m_es=(B*e_m_es)^thet*H_f_es^bet*H_m_es^(1-bet);

        Hpr_f_em=(B*e_f_es)^thet*H_f_em^bet*H_m_em^(1-bet);
        Hpr_f_es=(B*e_f_es)^thet*H_f_es^bet*H_m_es^(1-bet);
    
        % The discount factor to be applied is the mixed discount factor
        fac=gam*fac;

        % Update utilities
        V_m_em=V_m_em+fac*((1+sig)*(log(c_m_em)+log(c_f_em))/2+bet*log(n_es));
        V_m_es=V_m_es+fac*((1+sig)*(log(c_m_es)+log(c_f_es))/2+bet*log(n_es));
        
        i=i+1;

    end;

    disp('End of iteration');
    disp(V_m_em);
    disp(V_m_es);
    disp(' ');
    disp(thet);
    disp(' ');

    
    if V_m_em<V_m_es;
        % Adjust thet down
        thet_hi=thet;
        thet=0.5*thet_lo+0.5*thet;
    else;
        thet_lo=thet;
        thet=0.5*thet_hi+0.5*thet;    
    end;
    
    count=count+1;
    
end;

disp(['V_m_em is: ' num2str(V_m_em)]); 
disp(['V_m_es is: ' num2str(V_m_es)]);

disp(['Utility gap in favor of male power in e regime: ' num2str(V_m_em-V_m_es)]);

disp(['n_es: ' num2str(n_es)]);
disp(['n_em: ' num2str(n_em)]);

disp(['Critical theta: ' num2str(thet)]);

