% transition.m
% Based on the previously computed switching times, compute and plot the
% transition path
% Version February 2008


% Initialize results
H_f_m=ones(1,horizon+1);
H_m_m=ones(1,horizon+1);

H_f_o=ones(1,horizon+1);
H_m_o=ones(1,horizon+1);

e_f_m=zeros(1,horizon+1);
e_m_m=zeros(1,horizon+1);

e_f_o=zeros(1,horizon+1);
e_m_o=zeros(1,horizon+1);

n_m=zeros(1,horizon);
n_o=zeros(1,horizon);

% Compute choices under no-education regime.
n_nm=delt/(phi*(alph*(1+sig)+delt));

% First two periods are no-education regime for sure (given our calibration
% choices)
n_m(1,1:2)=n_nm*ones(1,2);
n_o(1,1:2)=n_nm*ones(1,2);

% Now turn to the periods where we might be in the education regime
% Value function parameters (needed for computing choices)
a2=(1+sig)*(2*alph+(1-alph)*bet*gam_f-alph*(1-bet)*gam_m)/(2-(1-bet)*gam_m-bet*gam_f);
b3=(1+sig)*(2*(1-alph)-(1-alph)*bet*gam_f+alph*(1-bet)*gam_m)/(2-(1-bet)*gam_m-bet*gam_f);

% Go through the remaining periods
count=3;
while count<=horizon;
    
    if count<=edu_switch_target;
        % We are still in the no education case
        n_m(1,count)=n_nm;
        n_o(1,count)=n_nm;
        
    else;
        % We are in the education case
        thet=thet_path(1,count);
        
        % First assign the patriarchal choices
        H_m=H_m_m(1,count);
        H_f=H_f_m(1,count);

        % Economic choices:
        e_m_m(1,count)=phi*(gam_m/2)*thet*a2/(delt-(gam_m/2)*thet*(a2+b3));
        e_f_m(1,count)=phi*(gam_m/2)*thet*b3/(delt-(gam_m/2)*thet*(a2+b3));

        n_m(1,count)=(delt-(gam_m/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));

        % Next male and female human capital
        H_m_m(1,count+1)=(B*e_m_m(1,count))^thet*H_f^bet*H_m^(1-bet);
        H_f_m(1,count+1)=(B*e_f_m(1,count))^thet*H_f^bet*H_m^(1-bet);
        
        % Now let's turn to the choices under optimal empowerment
        if count<crit_time;
            % No empowerment yet; outcome same as under permanent
            % patriarchy
            e_m_o(1,count)=e_m_m(1,count);
            e_f_o(1,count)=e_f_m(1,count);

            n_o(1,count)=n_m(1,count);

            H_m_o(1,count+1)=H_m_m(1,count+1);
            H_f_o(1,count+1)=H_f_m(1,count+1);

        
        else;
            % We are in the empowerment regime
            % First assign the patriarchal choices
            H_m=H_m_o(1,count);
            H_f=H_f_o(1,count);

            % Economic choices:
            e_m_o(1,count)=phi*(gam/2)*thet*a2/(delt-(gam/2)*thet*(a2+b3));
            e_f_o(1,count)=phi*(gam/2)*thet*b3/(delt-(gam/2)*thet*(a2+b3));

            n_o(1,count)=(delt-(gam/2)*thet*(a2+b3))/(phi*(alph*(1+sig)+delt));
                  
            % Next male and female human capital
            H_m_o(1,count+1)=(B*e_m_o(1,count))^thet*H_f^bet*H_m^(1-bet);
            H_f_o(1,count+1)=(B*e_f_o(1,count))^thet*H_f^bet*H_m^(1-bet);
            
        end;
    end;
   
    count=count+1;

end;
